<?php
if (!defined('ABSPATH')) exit;

class SS_AdminAssets {
    public static function init() {
        add_action('admin_enqueue_scripts', [__CLASS__, 'enqueue']);
    }
    public static function enqueue($hook) {
        // Only on our settings page
        $ok = ($hook === 'toplevel_page_searchshifter');
        if (!$ok && function_exists('get_current_screen')) {
            $s = get_current_screen();
            $ok = $s && strpos($s->id, 'searchshifter') !== false;
        }
        if (!$ok) return;

        wp_enqueue_style('ss-admin', SEARCHSHIFTER_PLUGIN_URL . 'assets/css/ss-admin.css', [], SEARCHSHIFTER_VERSION);
        wp_enqueue_script('ss-settings', SEARCHSHIFTER_PLUGIN_URL . 'assets/js/ss-settings.js', ['jquery'], SEARCHSHIFTER_VERSION, true);
        wp_localize_script('ss-settings','SSSettingsAjax',[
            'ajaxUrl' => admin_url('admin-ajax.php'),
            'nonce'   => wp_create_nonce('ss_test_connection'),
        ]);
    }
}
