<?php
/**
 * Admin Panel: GEO Diagnostics
 *
 * Location:
 * /wp-content/plugins/searchshifter/admin/class-ss-admin-geo-diagnostics.php
 *
 * Works with:
 * - includes/geo_diagnostics.php (engine)
 * - AJAX: ss_geo_run_scan
 * - Authority plan gating handled in SS_Setup
 */

if (!defined('ABSPATH')) exit;

if (!class_exists('SS_Admin_GEO_Diagnostics')) {

class SS_Admin_GEO_Diagnostics {

    /**
     * Render admin page
     */
    public static function render_page() {

        // Safety: check authority license
        $license = class_exists('SS_Licensing') ? SS_Licensing::get_cached_status() : [];
        $plan = strtolower($license['plan'] ?? 'free');

        if (!in_array($plan, ['authority', 'elite'], true)) {
            echo '<div class="wrap"><h1>🔒 GEO Diagnostics</h1>
                  <p>This feature requires the <strong>Authority</strong> or <strong>Elite</strong> edition.</p>
                  <a href="https://searchshifter.ai/pricing" class="button button-primary" target="_blank">Upgrade</a>
                  </div>';
            return;
        }

        ?>

        <div class="wrap ss-geo-wrap">
            <h1 style="margin-bottom: 10px;">🌐 GEO Diagnostics</h1>
            <p style="margin-bottom: 20px;">Run external Google & Perplexity checks, resolve DNS/CDN, and store evidence for AI visibility audits.</p>

            <div class="ss-geo-card" style="background:#fff;padding:25px;border-radius:8px;border:1px solid #e1e1e1;max-width:900px;">
                <h2>Run GEO Scan</h2>

                <table class="form-table">
                    <tr>
                        <th><label for="ss_geo_domain">Domain</label></th>
                        <td>
                            <input type="text" id="ss_geo_domain" class="regular-text" placeholder="example.com" />
                            <p class="description">Enter any domain connected to your AI visibility system.</p>
                        </td>
                    </tr>
                </table>

                <p>
                    <button class="button button-primary" id="ss_geo_run_btn">Run Scan</button>
                </p>

                <div id="ss_geo_loading" style="display:none;margin:10px 0;">
                    <span class="spinner is-active" style="float:none;visibility:visible;"></span>
                    Running GEO diagnostics…
                </div>

                <div id="ss_geo_results" style="margin-top:20px;"></div>
            </div>
        </div>

        <script>
        (function($){

            $('#ss_geo_run_btn').on('click', function(e){
                e.preventDefault();

                const domain = $('#ss_geo_domain').val();
                if (!domain) {
                    alert('Please enter a domain.');
                    return;
                }

                $('#ss_geo_loading').show();
                $('#ss_geo_results').html('');

                $.post(ajaxurl, {
                    action: 'ss_geo_run_scan',
                    domain: domain,
                    _nonce: '<?php echo wp_create_nonce("ss_geo_run_scan"); ?>'
                }, function(resp){

                    $('#ss_geo_loading').hide();

                    if (resp.success) {
                        $('#ss_geo_results').html(
                            '<h2>Scan Completed</h2><pre style="background:#1e1e1e;color:#c5f2ff;padding:20px;border-radius:5px;">'
                            + JSON.stringify(resp.data, null, 2)
                            + '</pre>'
                        );
                    } else {
                        $('#ss_geo_results').html(
                            '<div class="notice notice-error"><p>Error: ' + resp.data + '</p></div>'
                        );
                    }

                }).fail(function(xhr){
                    $('#ss_geo_loading').hide();
                    $('#ss_geo_results').html(
                        '<div class="notice notice-error"><p>Request failed: ' + xhr.responseText + '</p></div>'
                    );
                });

            });

        })(jQuery);
        </script>

        <style>
            .ss-geo-wrap h1 { font-size: 28px; }
            .ss-geo-card { box-shadow: 0 2px 6px rgba(0,0,0,0.06); }
            pre { white-space: pre-wrap; word-break: break-all; }
        </style>

        <?php
    }
}

}
