<?php
if (!defined('ABSPATH')) exit;

class SS_Admin_Schema_Scan {

    public static function init() {
        // Add Schema column for posts + pages
        add_filter('manage_post_posts_columns', [__CLASS__, 'add_column']);
        add_filter('manage_page_posts_columns', [__CLASS__, 'add_column']);

        add_action('manage_post_posts_custom_column', [__CLASS__, 'render_column'], 10, 2);
        add_action('manage_page_posts_custom_column', [__CLASS__, 'render_column'], 10, 2);

        // Make column sortable (optional)
        add_filter('manage_edit-post_sortable_columns', [__CLASS__, 'make_sortable']);
        add_filter('manage_edit-page_sortable_columns', [__CLASS__, 'make_sortable']);
    }

    /** Add the column */
    public static function add_column($columns) {
        $new = [];
        foreach ($columns as $key => $label) {
            $new[$key] = $label;
            if ($key === 'title') {
                $new['ss_schema'] = __('Schema', 'searchshifter');
            }
        }
        return $new;
    }

    /** Render content */
public static function render_column($column, $post_id) {
    if ($column !== 'ss_schema') return;

    $stored = get_post_meta($post_id, '_ss_schema_json', true);

    /* If no stored schema → definitely RED */
    if (empty($stored)) {
        echo '<span style="color:#d63638;font-size:16px;">●</span>';
        return;
    }

    /* TRUE SearchShifter-only fingerprints */
    $ss_fingerprints = [
        '"Glossary Terms Used On This Page"',   // Only SearchShifter glossary
        '"DefinedTermSet"',                     // SS glossary set
        '"DefinedTerm"',                        // SS glossary term
        '"mainEntity"'                          // Your SS FAQ builder
    ];

    foreach ($ss_fingerprints as $needle) {
        if (strpos($stored, $needle) !== false) {
            echo '<span style="color:#008a20;font-size:16px;">●</span>';
            return;
        }
    }

    // No SS schema found → RED
    echo '<span style="color:#d63638;font-size:16px;">●</span>';
}


    /** Make sortable (optional) */
    public static function make_sortable($columns) {
        $columns['ss_schema'] = 'ss_schema';
        return $columns;
    }
}

SS_Admin_Schema_Scan::init();
