<?php
if (!defined('ABSPATH')) exit;

$faq_items = get_option('ss_faq_items', []);

if ($_POST && check_admin_referer('save_faq_item')) {
    $question = sanitize_text_field($_POST['question']);
    $answer = sanitize_textarea_field($_POST['answer']);
    $faq_items[] = ['question' => $question, 'answer' => $answer];
    update_option('ss_faq_items', $faq_items);
}

if (isset($_GET['delete'])) {
    unset($faq_items[(int) $_GET['delete']]);
    update_option('ss_faq_items', $faq_items);
}
?>
<div class="wrap">
    <h1>FAQ Manager</h1>
    <form method="post">
        <?php wp_nonce_field('save_faq_item'); ?>
        <table>
            <tr><td><input type="text" name="question" placeholder="Question" required style="width:400px;"></td></tr>
            <tr><td><textarea name="answer" placeholder="Answer" style="width:400px;height:100px;"></textarea></td></tr>
        </table>
        <?php submit_button('Add FAQ'); ?>
    </form>

    <h2>Current FAQs</h2>
    <table class="widefat striped">
        <thead><tr><th>Question</th><th>Answer</th><th>Actions</th></tr></thead>
        <tbody>
        <?php foreach ($faq_items as $i => $faq): ?>
            <tr>
                <td><?= esc_html($faq['question']); ?></td>
                <td><?= esc_html($faq['answer']); ?></td>
                <td><a href="?page=searchshifter-faq&delete=<?= $i; ?>">Delete</a></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
