<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Register Visibility Scanner submenu (Pro)
add_action('admin_menu', function() {

    if ( SS_Licensing::has_feature('pro') ) {   // Gate by Pro license
        add_submenu_page(
            'searchshifter', // parent slug
            __('Visibility Scanner', 'searchshifter'), // page title
            __('Visibility Scanner', 'searchshifter'), // menu title
            'manage_options', // capability
            'searchshifter-visibility-scanner', // slug
            [ 'SS_Admin_Visibility_Scanner', 'render_page' ] // callback
        );

    } else {
        // Locked placeholder (for Free users)
        add_submenu_page(
            'searchshifter',
            __('Visibility Scanner (Locked)', 'searchshifter'),
            __('Visibility Scanner (🔒 Locked)', 'searchshifter'),
            'manage_options',
            'searchshifter-visibility-scanner-locked',
            function() {
                echo '<div class="wrap"><h1>🔒 Visibility Scanner</h1><p>This feature requires the <strong>Pro or Authority</strong> edition of SearchShifter.</p></div>';
            }
        );
    }

});
