jQuery(function($){
  const $btn = $('#ssTestConnBtn');
  const $msg = $('#ssTestConnMsg');

  if ($btn.length) {
    $btn.on('click', function(e){
      e.preventDefault();
      $msg.removeClass('ss-ok ss-err').text('Testing…');
      $btn.prop('disabled', true);

      $.post(SSSettingsAjax.ajaxUrl, {
        action: 'ss_test_connection',
        _ajax_nonce: SSSettingsAjax.nonce
      }).done(function(resp){
        if (resp && resp.success) {
          $msg.addClass('ss-ok').text(resp.data.message || 'OK');
        } else {
          const m = (resp && resp.data && resp.data.message) ? resp.data.message : 'Failed';
          $msg.addClass('ss-err').text(m);
        }
      }).fail(function(){
        $msg.addClass('ss-err').text('Network error');
      }).always(function(){
        $btn.prop('disabled', false);
      });
    });
  }
});
