<?php
if (!defined('ABSPATH')) exit;

class SS_Sync {
    public static function init() {
        // Re-queue when content changes
        add_action('save_post', [__CLASS__, 'queue_sync']);
        add_action('deleted_post', [__CLASS__, 'queue_sync']);
    }

    public static function queue_sync($post_id) {
        // Avoid autosaves / revisions
        if (wp_is_post_autosave($post_id) || wp_is_post_revision($post_id)) return;

        global $wpdb;
        $jobs = $wpdb->prefix . 'ss_jobs';

        // Insert a background job for Smart Sync
        $wpdb->insert($jobs, [
            'type'    => 'smart_sync',
            'payload' => maybe_serialize(['post_id' => $post_id]),
            'status'  => 'queued',
            'created_at' => current_time('mysql'),
        ]);

        do_action('ss_log', 'smart_sync', 'queued', ['post_id' => $post_id]);
    }
}
