<?php
class SS_Telemetry {
    const OPT = SS_Settings::OPT_TELEMETRY;

    public static function init() {
        // For M2 we do NOT send anything. We only prepare hooks we’ll use in M3.
        add_action('admin_init', [__CLASS__, 'maybe_note_status']);
        // Example future hooks (commented out for M2):
        // add_action('shutdown', [__CLASS__, 'maybe_queue_heartbeat']);
        // add_action('ss_event_schema_published', [__CLASS__, 'maybe_queue_event'], 10, 1);
    }

    /** Convenience: is telemetry allowed? */
    public static function enabled(): bool {
        return (bool) get_option(self::OPT, false);
    }

    /** M2: Just surface a tiny status note in our settings page footer (no logging, no network). */
    public static function maybe_note_status() {
        if (!current_user_can('manage_options')) return;
        if (!function_exists('get_current_screen')) return;
        $scr = get_current_screen();
        if (!$scr || strpos($scr->id, 'searchshifter') === false) return;

        $on = self::enabled();
        add_action('admin_notices', function() use ($on) {
            printf(
                '<div class="notice %1$s"><p><strong>Telemetry:</strong> %2$s (no data is sent in Milestone 2).</p></div>',
                $on ? 'notice-info' : 'notice-warning',
                $on ? 'enabled by admin' : 'disabled'
            );
        });
    }

    // ---------------------- M3 scaffold (NO-OP in M2) ----------------------
    // private static function maybe_queue_heartbeat() { if (!self::enabled()) return; /* queue a cron */ }
    // private static function maybe_queue_event($payload) { if (!self::enabled()) return; /* enqueue */ }
    // private static function send($endpoint, array $data) { /* wp_remote_post(...) */ }
}
