
<?php
if (!defined('ABSPATH')) exit;

class SS_Admin_Notices {
    const OPT = '_ss_admin_notices_queue';

    public static function init() {
        add_action('admin_notices', [__CLASS__, 'render']);
    }

    public static function success($msg){ self::queue('success', $msg); }
    public static function warning($msg){ self::queue('warning', $msg); }
    public static function error($msg){ self::queue('error', $msg); }
    public static function info($msg){ self::queue('info', $msg); }

    private static function queue($type, $msg){
        $q = (array) get_option(self::OPT, []);
        $q[] = ['t'=>$type, 'm'=>$msg];
        update_option(self::OPT, $q, false);
    }

    public static function render(){
        $q = (array) get_option(self::OPT, []);
        if (empty($q)) return;
        delete_option(self::OPT);

        foreach ($q as $n){
            $type = in_array($n['t'], ['success','warning','error','info'], true) ? $n['t'] : 'info';
            $cls  = 'notice-' . ($type === 'success' ? 'success' : ($type === 'error' ? 'error' : 'warning'));
            printf('<div class="notice %s is-dismissible"><p>%s</p></div>', esc_attr($cls), wp_kses_post($n['m']));
        }
    }
}
