<?php
if (!defined('ABSPATH')) exit;

class SS_AdminAssets {
    public static function init() {
        add_action('admin_enqueue_scripts',        [__CLASS__, 'enqueue']);
        add_action('admin_print_footer_scripts',   [__CLASS__, 'inline_js']);
        add_action('add_meta_boxes_ss_qa', [__CLASS__, 'hide_pairs_box'], 99);
    }

    /** Determine whether we're on the SearchShifter settings page */
    private static function on_settings_page(): bool {
        if (isset($_GET['page']) && $_GET['page'] === 'searchshifter') return true;

        if (function_exists('get_current_screen')) {
            $s = get_current_screen();
            if ($s && (
                $s->id === 'toplevel_page_searchshifter' ||
                strpos($s->id, 'searchshifter') !== false
            )) {
                return true;
            }
        }
        return false;
    }

    public static function hide_pairs_box() {
        remove_meta_box('ssqa_pairs', 'ss_qa', 'normal');
    }
    public static function enqueue($hook) {
        if (!self::on_settings_page()) return;

        wp_enqueue_style(
            'ss-admin',
            SEARCHSHIFTER_PLUGIN_URL . 'assets/css/ss-admin.css',
            [],
            SEARCHSHIFTER_VERSION
        );

        wp_enqueue_script(
            'ss-settings',
            SEARCHSHIFTER_PLUGIN_URL . 'assets/js/ss-settings.js',
            ['jquery'],
            SEARCHSHIFTER_VERSION,
            true
        );

        wp_localize_script('ss-settings', 'SSSettingsAjax', [
            'ajaxUrl' => admin_url('admin-ajax.php'),
            'nonce'   => wp_create_nonce('ss_test_connection'),
        ]);
    }

    /** Small page-specific helpers (copy / reveal / disable run button) */
    public static function inline_js() {
        if (!self::on_settings_page()) return; ?>
        <script>
        (function(){
          // COPY: any button with .ss-copy-btn and data-copy-target="#inputId"
          document.querySelectorAll('.ss-copy-btn').forEach(function(btn){
            btn.addEventListener('click', function(e){
              e.preventDefault();
              var sel = btn.getAttribute('data-copy-target');
              var el  = sel ? document.querySelector(sel) : null;
              if (!el) return;

              el.select();
              el.setSelectionRange(0, 99999);
              try { document.execCommand('copy'); } catch(e){}
              btn.classList.add('is-copied');
              setTimeout(function(){ btn.classList.remove('is-copied'); }, 1200);
              el.setSelectionRange(0,0); el.blur();
            });
          });

          // REVEAL: any button with .ss-reveal-btn and data-reveal-target="#inputId"
          document.querySelectorAll('.ss-reveal-btn').forEach(function(btn){
            btn.addEventListener('click', function(e){
              e.preventDefault();
              var sel = btn.getAttribute('data-reveal-target');
              var el  = sel ? document.querySelector(sel) : null;
              if (!el) return;

              el.type = (el.type === 'password') ? 'text' : 'password';
              btn.classList.toggle('is-on', el.type === 'text');
            });
          });

          // VISIBILITY SCORE: disable button while posting
          var form = document.getElementById('ss-score-form');
          if (form){
            form.addEventListener('submit', function(){
              var btn = document.getElementById('ssRunScoreBtn');
              if (btn){
                btn.disabled = true;
                btn.textContent = 'Running…';
              }
            });
          }
        })();
        </script>
        <?php
    }
}
