<?php

class SS_API {

    public static function init(){

        add_action('rest_api_init', function(){



            // ---- Existing status route (unchanged) ----

            register_rest_route('searchshifter/v1','/status',[

                'methods'  => 'GET',

                'permission_callback' => '__return_true',

                'callback' => function(){

                    $lic = SS_Licensing::get_cached_status();

                    return [

                        'version'         => SEARCHSHIFTER_VERSION,

                        'ok'              => true,

                        'license'         => $lic,

                        'readonly'        => ! $lic['active'],

                        'features'        => (array) get_option(SS_Settings::OPT_FEATURE_FLAGS, []),

                        'telemetry_opt_in'=> (bool) get_option(SS_Settings::OPT_TELEMETRY, false),

                    ];

                }

            ]);



            // ---- NEW: Milestone 5 – public AI Light Checker route ----

            register_rest_route('searchshifter/v1','/light-check',[

                'methods'  => ['GET','POST'],

                'permission_callback' => '__return_true', // public endpoint

                'args'     => [

                    'url' => [

                        'required' => true,

                        'type'     => 'string',

                    ],

                ],

                'callback' => function(\WP_REST_Request $req){

                    $url = (string) $req->get_param('url');

error_log('[SS_API] light-check route triggered for URL: ' . $url);


                    // Lazy-load the class via autoloader path includes/Core/LightChecker.php

                    if (!class_exists('\\SS\\Core\\LightChecker')) {

                        $path = SEARCHSHIFTER_PLUGIN_DIR . 'includes/Core/LightChecker.php';

                        if (file_exists($path)) require_once $path;

                    }



                    if (!class_exists('\\SS\\Core\\LightChecker')) {

                        return new \WP_REST_Response(['ok'=>false,'error'=>'LightChecker class missing'], 500);

                    }


error_log('[SS_API] returning result for ' . $url);

                    $res = \SS\Core\LightChecker::scan($url);

                    $code = (!empty($res['ok'])) ? 200 : 400;

                    return new \WP_REST_Response($res, $code);

                }

            ]);



        });

    }

}

