<?php
// Archive template for Glossary Terms

if (!defined('ABSPATH')) exit;

$terms = new WP_Query([
    'post_type' => 'ss_glossary',
    'posts_per_page' => -1,
    'orderby' => 'title',
    'order' => 'ASC'
]);
?>

<div class="ss-glossary-archive" style="max-width:900px;margin:40px auto;font-family:system-ui;">

    <h1>Glossary</h1>

    <?php if ($terms->have_posts()): ?>
        <ul style="list-style:none;padding:0;">
        <?php while ($terms->have_posts()): $terms->the_post(); ?>
            
            <li style="margin-bottom:20px;">
                <a href="<?php the_permalink(); ?>"
                    style="font-size:18px;font-weight:bold;color:#2271b1;text-decoration:none;">
                    <?php the_title(); ?>
                </a>
            </li>

        <?php endwhile; ?>
        </ul>

    <?php else: ?>
        <p>No glossary terms found.</p>
    <?php endif; ?>

</div>

<?php wp_reset_postdata(); ?>
