// includes/class-ss-llms.php (if you don’t already have one)
<?php
if (!defined('ABSPATH')) exit;

class SS_LLMS {
    public static function init() {
        add_action('template_redirect', [__CLASS__, 'maybe_serve']);
    }
    public static function maybe_serve() {
        if (trim($_SERVER['REQUEST_URI'] ?? '', '/') !== 'llms.txt') return;

        // If a real file exists at docroot, let WP serve it normally
        if (file_exists(ABSPATH . 'llms.txt')) return;

        if (class_exists('SS_AI_Protocol')) {
            $payload = SS_AI_Protocol::preview_llms() . "\n";
            header('Content-Type: text/plain; charset=utf-8');
            header('X-Robots-Tag: all');
            echo $payload;
            exit;
        }
    }
}
