<?php
/**
 * Frontend FAQ Display Template
 * Path: /includes/faq-display.php
 */

if (!defined('ABSPATH')) exit;

$faqs = get_option('ss_faq_items', []);

if (empty($faqs)) {
    echo '<p>No FAQs found. Please add some in the admin panel.</p>';
    return;
}
?>

<section class="ss-public-faq">
  <h2>Frequently Asked Questions</h2>
  <div class="faq-list">
    <?php foreach ($faqs as $faq): ?>
      <details>
        <summary><?= esc_html($faq['question']); ?></summary>
        <div><?= wpautop(esc_html($faq['answer'])); ?></div>
      </details>
    <?php endforeach; ?>
  </div>
</section>

<style>
/* --------------------------------------------
   SearchShifter™ FAQ - Frontend Dropdown Style
--------------------------------------------- */
.ss-public-faq {
  max-width: 800px;
  margin: 40px auto;
  font-family: system-ui, -apple-system, "Segoe UI", Roboto, sans-serif;
}
.ss-public-faq details {
  border: 1px solid #ddd;
  border-radius: 8px;
  background: #fff;
  margin-bottom: 10px;
  padding: 12px 16px;
  transition: all 0.25s ease;
}
.ss-public-faq details:hover {
  background: #f9f9f9;
}
.ss-public-faq summary {
  font-weight: 600;
  font-size: 16px;
  cursor: pointer;
  position: relative;
  list-style: none;
}
.ss-public-faq summary::-webkit-details-marker {
  display: none;
}
.ss-public-faq summary::after {
  content: '+';
  position: absolute;
  right: 0;
  color: #2271b1;
  font-weight: bold;
  transition: transform 0.2s ease;
}
.ss-public-faq details[open] summary::after {
  content: '−';
  transform: rotate(180deg);
}
.ss-public-faq div {
  margin-top: 8px;
  color: #333;
  font-size: 15px;
  line-height: 1.5;
}
</style>
