<?php
/**
 * Frontend Glossary Display Template
 * Path: /includes/glossary-display.php
 */

if (!defined('ABSPATH')) exit;

$glossary = get_option('ss_glossary_terms', []);

if (empty($glossary)) {
    echo '<p>No glossary terms found. Please add some in the admin panel.</p>';
    return;
}
?>

<section class="ss-public-glossary" itemscope itemtype="https://schema.org/DefinedTermSet">
  <meta itemprop="name" content="SearchShifter Glossary" />

  <?php foreach ($glossary as $item): ?>
    <details itemscope itemtype="https://schema.org/DefinedTerm" itemprop="hasDefinedTerm">
      <summary itemprop="name"><?= esc_html($item['term']); ?></summary>

      <div itemprop="description">
        <?= wpautop(esc_html($item['definition'])); ?>

        <?php if (!empty($item['same_as'])): ?>
          <p>
            <a href="<?= esc_url($item['same_as']); ?>" target="_blank" rel="noopener" itemprop="sameAs">
              Learn more
            </a>
          </p>
        <?php endif; ?>
      </div>
    </details>
  <?php endforeach; ?>

  <?php
$terms_json = [];
foreach ($glossary as $g) {
  $term = [
    "@type" => "DefinedTerm",
    "name" => wp_strip_all_tags($g['term']),
    "description" => wp_strip_all_tags($g['definition']),
  ];
  if (!empty($g['same_as'])) $term["sameAs"] = esc_url_raw($g['same_as']);
  $terms_json[] = $term;
}

$definedSet = [
  "@context" => "https://schema.org",
  "@type" => "DefinedTermSet",
  "name" => "SearchShifter Glossary",
  "hasDefinedTerm" => $terms_json,
];
?>
<?php
// Note: Full schema is now injected via includes/schema-glossary.php
// No inline JSON-LD output required here.
?>

</section>

<style>
/* --------------------------------------------
   SearchShifter™ Glossary - Frontend Dropdown Style
--------------------------------------------- */
.ss-public-glossary {
  max-width: 800px;
  margin: 40px auto;
  font-family: system-ui, -apple-system, "Segoe UI", Roboto, sans-serif;
}
.ss-public-glossary details {
  border: 1px solid #ddd;
  border-radius: 8px;
  background: #fff;
  margin-bottom: 10px;
  padding: 12px 16px;
  transition: all 0.25s ease;
}
.ss-public-glossary details:hover {
  background: #f9f9f9;
}
.ss-public-glossary summary {
  font-weight: 600;
  font-size: 16px;
  cursor: pointer;
  list-style: none;
  position: relative;
}
.ss-public-glossary summary::-webkit-details-marker {
  display: none;
}
.ss-public-glossary summary::after {
  content: '+';
  position: absolute;
  right: 0;
  color: #2271b1;
  font-weight: bold;
  transition: transform 0.2s ease;
}
.ss-public-glossary details[open] summary::after {
  content: '−';
  transform: rotate(180deg);
}
.ss-public-glossary [itemprop="description"] {
  margin-top: 8px;
  color: #333;
  font-size: 15px;
  line-height: 1.5;
}
.ss-public-glossary a[itemprop="sameAs"] {
  color: #2271b1;
  text-decoration: none;
  font-weight: 500;
}
.ss-public-glossary a[itemprop="sameAs"]:hover {
  text-decoration: underline;
}
.ss-public-glossary summary:focus {
  outline: 3px solid rgba(34,113,177,0.25);
  outline-offset: 3px;
}

</style>
