<?php
class SS_QA {
    public static function init() {
        // Only register the CPT if the feature flag is on
        $flags = (array) get_option(SS_Settings::OPT_FEATURE_FLAGS, []);
        if (in_array('qa', $flags, true)) {
            add_action('init',[__CLASS__,'register_cpt']);
            add_action('save_post_ss_qa',[__CLASS__,'on_save'],10,3);
        }
    }

    public static function register_cpt() {
        register_post_type('ss_qa', [
            'label' => 'Q&A',
            'public' => true,
            'show_ui' => true,
            'supports' => ['title','editor','revisions'],
            'capability_type' => 'post',
            'map_meta_cap' => true,
            'menu_icon' => 'dashicons-editor-help',
        ]);
    }

    public static function on_save($post_id,$post,$update){
        // License / flag gates are re-checked in SS_Schema::generate_schema
        do_action('ss_index_refresh',$post_id);
    }
}
