(function () {

  document.addEventListener('DOMContentLoaded', function () {

    const form = document.getElementById('ss-light-form');

    if (!form) return;

    form.addEventListener('submit', async (e) => {

      e.preventDefault();

      const url = document.getElementById('ss-light-url').value.trim();

      const out = document.getElementById('ss-light-result');

      out.innerHTML = 'Checking…';

      try {

        const res = await fetch(SS_LIGHT.endpoint, {

          method: 'POST',

          headers: { 'Content-Type': 'application/json' },

          body: JSON.stringify({ url })

        });

        const data = await res.json();

        if (!data.ok) {

          out.innerHTML = `<div style="color:#b00;">${data.error || 'Scan failed'}</div>`;

          return;

        }

        const issues = (data.issues || []).map(i => `<li>${i}</li>`).join('');

        out.innerHTML = `

          <div style="border:1px solid #eee;padding:16px;border-radius:8px;">

            <h4>AI Quotability Score: ${data.score}/100</h4>

            <p><strong>Top Issues:</strong></p>

            <ul>${issues}</ul>

            <p style="font-size:0.9em;opacity:.7;">${data.cta}</p>

          </div>`;

      } catch (err) {

        out.innerHTML = '<div style="color:#b00;">Network error.</div>';

      }

    });

  });

})();

