<?php
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

/** ------------------------------
 * Core Licensing & Identity
 * ------------------------------ */
// delete_option('ss_api_key');
delete_option('ss_domain');
// delete_option('ss_plan_type');
// delete_option('ss_api_base');

/** Cached license (for DB-backed transients) */
delete_option('ss_license_status');
delete_transient('ss_license_status');

/** ------------------------------
 * Telemetry + install id
 * ------------------------------ */
delete_option('ss_telemetry_opt_in');
delete_option('ss_installation_id');

/** ------------------------------
 * AI Policy page (only if auto-created)
 * ------------------------------ */
$page_id = (int) get_option('ss_ai_policy_page_id');
if ($page_id > 0) {
    if (get_post_meta($page_id, '_ss_ai_autocreated', true)) {
        wp_delete_post($page_id, true);
    }
}
delete_option('ss_ai_policy_page_id');

/** ------------------------------
 * llms.txt file pointer
 * ------------------------------ */
$llms_path = get_option('ss_llms_written_path');
if ($llms_path && @file_exists($llms_path)) {
    @unlink($llms_path);
}
delete_option('ss_llms_written_path');

/** ------------------------------
 * Organization sync
 * ------------------------------ */
delete_option('ss_org_sync');
